<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  public function up(): void
  {
    Schema::create('courses', function (Blueprint $table) {
      $table->id();
      $table->timestamps();
      $table->string("name")->unique();
      $table->string("image")->unique();
      $table->string("duration");
      $table->string("description");
      $table->integer("fee");
    });
  }

  public function down(): void
  {
    Schema::dropIfExists('courses');
  }
};
